 
/******************************************************************************* 
* Freescale Semiconductor Inc. 
* (c) Copyright 2004-2005 Freescale Semiconductor, Inc. 
* ALL RIGHTS RESERVED. 
******************************************************************************** 
Services performed by FREESCALE in this matter are performed AS IS and without  
any warranty. CUSTOMER retains the final decision relative to the total design  
and functionality of the end product. FREESCALE neither guarantees nor will be  
held liable by CUSTOMER for the success of this project. 
FREESCALE DISCLAIMS ALL WARRANTIES, EXPRESSED, IMPLIED OR STATUTORY INCLUDING,  
BUT NOT LIMITED TO, IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR  
A PARTICULAR PURPOSE ON ANY HARDWARE, SOFTWARE ORE ADVISE SUPPLIED TO A PROJECT 
BY FREESCALE, AND OR NAY PRODUCT RESULTING FROM FREESCALE SERVICES. IN NO EVENT 
SHALL FREESCALE BE LIABLE FOR INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF 
THIS AGREEMENT. 
 
CUSTOMER agrees to hold FREESCALE harmless against any and all claims demands or  
actions by anyone on account of any damage, or injury, whether commercial,  
contractual, or tortuous, rising directly or indirectly as a result of an advise 
or assistance supplied CUSTOMER in connection with product, services or goods  
supplied under this Agreement. 
******************************************************************************** 
* File      template.h 
* Owner     r62780 
* Version   1.1   note:version 0.x is reserved for development phase and should  
                  not be placed in the repository 
* Date      Mar-10-2010 
* Classification   General Business Information / Internal Use Only / Confidential 
Proprietary 
* Brief     Brief description of the file 
******************************************************************************** 
* Detailed Description: 
******************************************************************************** 
Revision History: 
Version    Date    Author    Description of Changes 
*******************************************************************************/ 
#ifndef USB2CAN_H_
#define USB2CAN_H_

/******************************************************************************* 
* Includes 
*******************************************************************************/ 
 
/******************************************************************************* 
* Constants 
*******************************************************************************/ 
#define PC_PACKET_HEADER    0x55U
#define PC_PACKET_ENDER     0xAAU

#define OPERATION_OK        0x00U
#define OPERATION_FAIL      0xFFU

#define ERR_OK              0x00U
#define TIMEOUT_ERR         0x01U
#define RESPONSE_DATA_ERR   0x02U
#define FRAMEING_ERR        0x10U
#define CMD_WORD_ERR        0x11U
#define CHECKSUM_ERR        0x12U


/******************************************************************************* 
* Macros  
*******************************************************************************/
#define BDG_SEND_BLKCHK_RESULT    0x81U
#define BDG_SEND_FLASH_CONTENT    0x80U
#define BDG_SEND_UNSEC_RESULT     0x82U
#define BDG_ACK_CMD               0xFFU
/* Bridge commands to target */
#define BDG_UNSEC_TG           0x010U
#define BDG_SET_ADDR           0x011U
#define BDG_LOAD_DATA          0x012U
#define BDG_MASS_ERASE_TG      0x013U
#define BDG_SECT_ERASE_TG      0x014U
#define BDG_BURST_PROG_TG      0x015U
#define BDG_BYTE_PROG_TG       0x016U
#define BDG_BLANK_CHECK_TG     0x017U
#define BDG_READ_TG            0x018U

#define CMD_SEND_MB(CMD)       (CMD) /* mailbox for transmiting command */
#define RESPONSE_REC_MB(CMD) (CMD - 0x10U) /* mailbox for receiving response
                                                         /* for each command */
/* overt timer control marco */
#define START_OVERTIMER_CNT    (RTCSC = 0x8F)
#define STOP_OVERTIMER_CNT     (RTCSC = 0x80)
#define OVERTIMER_FLAG          RTCSC_RTIF
#define CLEAR_OVTM_FLG         (RTCSC_RTIF = 1U)
/******************************************************************************* 
* Types 
*******************************************************************************/ 
 
enum
{
    PC_SET_CAN_BR = 0U,
    PC_MASS_ERASE_TG,
    PC_SECTOR_ERASE_TG,
    PC_BLK_CHK_TG,
    PC_PROG_TG,
    PC_VERIFY_TG,
    PC_READ_TG,
    PC_UNSECURE_TG
} ;

typedef struct
{
    uint_8 pc_cmd;
    uint_8 data_length;
    uint_8 data[DATA_BUFF_SIZE - 11U];
    uint_8 checksum;
}PC_CMD_TYPE;

/******************************************************************************* 
* Global variables declaration
*******************************************************************************/ 
extern PC_CMD_TYPE current_pc_cmd;
extern uint_8 g_error_status;
/******************************************************************************* 
* Global functions 
*******************************************************************************/ 
extern uint_8 USB2CAN_Task(void);
extern void USB2CAN_Init(void);
 
/******************************************************************************* 
* Inline functions 
*******************************************************************************/ 
 

#endif /* USB2CAN_H_ */
